<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Login</title>
    <link href="<?php echo e(asset('assets/vendor/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/auth.css')); ?>" rel="stylesheet">
</head>

<body class="bg-color">
    <style>
        .bg-color{
            background: #302b631a;
            position: relative;
        }
        .top-linear{
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 60px;
            contain: '';
            z-index: 1;
            background: linear-gradient(180deg, #302b6342 0%, rgba(48, 43, 99, 0.00) 100%);
        }
        .bottom-linear{
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 60px;
            contain: '';
            background: linear-gradient(0deg, #302b6342 0%, rgba(48, 43, 99, 0.00) 100%);
        }
        img.brand {
            width: 120px;
            height: auto;
        }
        .auth-content .card {
            border-top: 2px solid #302B63;
        }
        .auth-content .card h4 {
            font-size: 1.5rem;
            color: #666;
        }
        label.form-label{
            color: #666;
            font-size: 16px;
            font-weight: 600;
        }
        label.form-check-label{
            color: #666;
            font-size: 16px;
        }
        .auth-content{
            max-width: 400px;
            padding: 0px;
        }
        input#email, input#password{
            border-radius: 5px;
            background: #fff;
            border-color: #e4e6fc;
            font-size: 16px;
            color: #666;
        }
        input#email:focus, input#password:focus{
            border-color: #302B63;
            box-shadow: unset;
        }
        .btn-login{
            border-color: #302B63;
            background: #302B63 !important;
            color: #fff;
            padding: 0.55rem 1.5rem;
            font-size: 14px;
            width: 100%;
            font-weight: 600;
            line-height: 24px;
            letter-spacing: .5px;
        }
        .form-check-input{
            border-color: #302B63;
        }
        .form-check-input:checked {
            background-color: #302B63;
            border-color: #302B63;
        }
        .form-check-input:focus{
            box-shadow: unset;
        }
        .login-tittel{
            padding: 20px 25px;
            border-bottom: 1px solid #e4e6fc;
        }
    </style>
    <div class="top-linear"></div>
    <div class="bottom-linear"></div>
    <div class="wrapper">
        <div class="auth-content">
            <div class="mb-4 text-center">
                <img class="brand" src="<?php echo e(asset('logo.png')); ?>" alt="logo">
            </div>
            <div class="card">
                <h4 class="text-muted login-tittel">Login as Admin</h4>
                <div class="card-body pt-2">
                    
                    
                    <form method="POST" action="<?php echo e($url); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3 text-start">
                            <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
                             <input id="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>
                            
                             <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-3 text-start">
                            <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                            <input id="password" type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required autocomplete="current-password">
                            
                        </div>
                        <div class="mb-3 text-start">
                            <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="remember">
                                    <?php echo e(__('Remember Me')); ?>

                                </label>
                              
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary btn-login">
                                    <?php echo e(__('Login')); ?>

                        </button>
                        
                    </form>
                    
                    
                </div>
            </div>
            </form>
        </div>
    </div>
    
    <script src="<?php echo e(asset('assets/vendor/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendor/bootstrap/js/bootstrap.min.js')); ?>"></script>
</body>

</html><?php /**PATH D:\laragon\www\Lotto\resources\views/auth/admin_login.blade.php ENDPATH**/ ?>