
<?php $__env->startSection('content'); ?>
<style>
  a {
    text-decoration: none;
  }

  span {
    color: white;
  }

  table,
  thead,
  tr,
  td {
    color: white;
  }

  section.ticket {
    display: flex;
    justify-content: center;
  }

  .multisteps_form {
    margin: 0rem 0rem;
    padding: 2rem 15px !important;
  }

  .card {
    background-image: linear-gradient(to right, #0f0c29, #302b63, #24243e);
    box-shadow: rgb(254 254 254 / 22%) 0px 5px 15px !important;
    border-radius: 10px;
    border: 1px solid #ffffff38;
  }

  .span-tittel {
    width: 105px;
    display: inline-block;
  }

  #checker-content {
    padding: 15px 20px 0px;
    text-align: center;
  }

  .line {
    position: relative;
    display: inline-block;
    padding: 20px 0 30px;
    border-bottom: 1px solid #ffffff38;
  }

  .numbers {
    align-items: center;
    display: flex;
  }

  .numbers ul {
    margin-bottom: 0px;
  }

  .numbers ul,
  .numbers li {
    position: relative;
    list-style-type: none;
    display: inline-block;
  }

  .numbers ul:first-child {
    margin-right: 30px;
  }

  .numbers input {
    border: none;
    border-radius: 8px;
    padding: 5px;
    font-size: 30px;
    font-weight: bold;
    text-align: center;
    width: 70px;
    height: 70px;
    margin: 0 2px;
  }

  .clean {
    position: relative;
    font-size: 30px;
    padding-left: 20px;
    cursor: pointer;
  }

  #checker-reset,
  .clean {
    display: inline-block;
  }

  #checker button {
    display: inline-block;
    -webkit-appearance: none;
    background: none;
    border: none;
    color: #0A8901;
    padding: 10px;
    font-size: 20px;
    margin-bottom: 20px;
    cursor: pointer;
    margin-left: auto;
    margin-right: auto;
  }

  .btn.clean.btn-danger {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 60px;
    height: 60px;
    padding: 0px;
    border-radius: 8px;
  }

  .main-label {
    margin-bottom: 5px;
  }

  .form-control {
    background: transparent;
    color: #fff;
    border: 1px solid #ffffff38;
  }

  .form-control:focus {
    background: transparent;
    color: #fff;
    border: 1px solid #FFFFFF;
    box-shadow: none;
  }

  .form-control::placeholder {
    color: #fff;
  }
</style>
<section class="ticket">
  <div class="multisteps_form  position-relative overflow-hidden">
    <a href="<?php echo e(route('/')); ?>" class="back-button btn btn-primary"><i class="fa fa-arrow-left" aria-hidden="true"></i>Back To Home</a>
    <div class="card bg-gray mt-5 p-5">
      <div class="row justify-content-between align-items-center">
        <div class="col-md-8">
          <div class="row">
            <div class="col-md-6 mb-3">
              <div class="form-group">
                
                <span><?php echo e($gameDetail->game_title); ?></span>
              </div>
            </div>
            <div class="col-md-6 mb-3">
              <div class="form-group">
                
                <span><?php echo e(substr($gameDetail->game_description, 0, 25)); ?></span>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                
                <span><?php echo e($gameDetail->game_end_date); ?></span>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-2">
          <?php if($gameDetail->featured_image): ?>
          <img src="<?php echo e(asset('game_images/'.$gameDetail->featured_image)); ?>" class="rounded d-block img-fluid" alt=""
            style="height: auto;width: 100px;float: right;width:100% !important;">
          <?php else: ?>
          <img src="<?php echo e(asset('logo.png')); ?>" class="rounded d-block img-fluid" alt=""
            style="height: auto;width: 100px;float: right;width:100% !important;">
          <?php endif; ?>
        </div>
      </div>
    </div>
    
  <div class="card bg-gray mt-5 p-5">
    <form action="<?php echo e(route('user.store.ticket')); ?>" method="POST" id="checker">
      <?php echo csrf_field(); ?>
      <input type="hidden" name="game_id" value="<?php echo e($gameDetail->id); ?>">
      <p style="padding: 20px 30px; margin: 0 0 -30px; text-align: center;">Choose numbers</strong></p>

      <div id="checker-content">
        <div id="checker-lines">
          <div class="line" data-index="0">
            <div class="numbers">
              <input type="hidden" name="ticket_row[]" value="1">
              <ul class="p-0">
                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

                <li>
                  <input type="tel" min="1" name="ticket_number[0][]" maxlength="2">
                </li>

              </ul>

              <div class="btn clean btn-danger" style="margin-left: 20px" data-type="result">×</div>
            </div>

          </div>
        </div>
      </div>
      <div class="d-flex justify-content-center w-100">
        <div class="text-center">
          <button id="checker-add" value="+ Add Line" type="button" style="visibility: visible;">+ Add Line</button>
          <div class="form-group mb-3">
            <label for="" class="text-white main-label">Amount($) <span class="text-danger">*</span></label>
            <input type="number" class="form-control ticket-price" name="price"
              value="<?php echo e($gameDetail->game_ticket_prize != '' ? $gameDetail->game_ticket_prize : '0'); ?>" id="priceInput" style="color: black;"  readonly>
          </div>
          <div id="checker-footer">
            
            <div>
              
              
                
              
              
              <input type="submit" id="checker-submit" value="Place Ticket" class="btn btn-success">
            </div>
          </div>
        </div>
      </div>


    </form>
  </div>
</section>


<!--- JS WORK -->
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
<script>
// New Code
$(document).ready(function() {
  var ticketRow = 1;

  // Get the initial ticket price value
  var ticketPrice = parseFloat($(".ticket-price").val());

  // Calculate the initial total price
  var totalPrice = ticketPrice;

  // Function to update the total price
  function updateTotalPrice() {
    var totalRows = $(".line").length;
    totalPrice = ticketPrice * totalRows;
    $("#priceInput").val(totalPrice);
  }

  // Function to update ticket_number attributes
  function updateTicketNumbers() {
    $(".line").each(function(index) {
      var currentRow = index;
      $(this).find("input[name^='ticket_number']").attr("name", "ticket_number[" + currentRow + "][]");
      $(this).find(".delete-row").attr("data-ticket-row", currentRow + 1);
    });
  }

  // Add a click event listener to the "Add Line" button
  $("#checker-add").click(function() {
    // Clone the first line element
    var newLine = $("#checker-lines .line").first().clone();

    // Increment the ticketRow value
    ticketRow++;

    // Set the ticket_row value in the cloned line
    newLine.find("input[name^='ticket_row']").val(ticketRow);

    // Clear the input values in the cloned line
    newLine.find("input[type='tel']").val("");

    // Remove the trash icon from the cloned line
    newLine.find(".delete-row").remove();

    // Append the new line to the lines container
    $("#checker-lines").append(newLine);

    // Show the delete button for the cloned line
    newLine.find(".numbers").prepend('<div class="btn clean btn-danger delete-row" style="margin-right: 20px" data-ticket-row="' + ticketRow + '"><i class="fa fa-trash" aria-hidden="true"></i></div>');

    // Update the ticket_number attributes
    updateTicketNumbers();

    // Update the total price
    updateTotalPrice();
  });

  // Add a click event listener to the "Clear Row" button
  $(document).on("click", ".clear-row", function() {
    // Find the parent line element
    var line = $(this).closest(".line");

    // Clear the input values in the line
    line.find("input[type='tel']").val("");

    // Update the total price after clearing the row
    updateTotalPrice();
  });

  // Add a click event listener to the "Delete Row" button
  $(document).on("click", ".delete-row", function() {
    // Find the parent line element
    var line = $(this).closest(".line");

    // Get the ticket_row value
    var ticketRowValue = line.find("input[name^='ticket_row']").val();

    // Remove the line from the lines container
    line.remove();

    // Decrement the ticketRow value
    ticketRow--;

    // Update the ticket_number attributes
    updateTicketNumbers();

    // Update the total price after deleting the row
    updateTotalPrice();
  });

  // Initial total price display
  updateTotalPrice();

  // Initial ticket_number and delete button ticket_row update
  updateTicketNumbers();
});




// New Code Ends

// $(document).ready(function() {
//   var lineIndex = $('.line').length; // Set lineIndex based on existing rows

//   // Hide the trash icon for the first row initially
//   $('.numbers .btn.clean.btn-danger').first().hide();

//   // Add Line button click event
//   var rowCount = 0; // Variable to keep track of the row count

// $('#checker-add').click(function() {
//   var current_amount = parseFloat($('.ticket-price').val()); // Get the current value and convert it to a number
//   var rows = $('.row'); // Get all the rows
  
//   rowCount = rows.length; // Update the row count
  
//   current_amount *= rowCount; // Multiply the current value by the row count
//   $('.ticket-price').val(current_amount); // Update the input field with the new value

//     var lineTemplate = $('.line').first().clone(); // Clone the first line template
//     lineTemplate.attr('data-index', lineIndex); // Set the data-index attribute
//     lineTemplate.find('input').attr('name', `ticket_number[${lineIndex}][]`); // Update input field names

//     // Append the new line template to the checker-lines container
//     $('#checker-lines').append(lineTemplate);

//     // Show the trash icon for newly added lines
//     lineTemplate.find('.btn.clean.btn-danger').show();

//     // Remove Line button click event
//     lineTemplate.find('.btn.clean.btn-danger').click(function() {
//       var line = $(this).closest('.line');
//       var currentIndex = line.data('index');
//       line.remove();

//       // Update lineIndex for the remaining lines
//       $('.line').each(function(index) {
//         var newIndex = index;
//         if (index >= currentIndex) {
//           newIndex++;
//         }
//         $(this).attr('data-index', newIndex);
//         $(this).find('input').attr('name', `ticket_number[${newIndex}][]`);
//       });

//       // Hide the trash icon for the first row
//       $('.numbers .btn.clean.btn-danger').first().hide();

//       // Update lineIndex based on remaining rows
//       lineIndex = $('.line').length;
//     });

//     // Increment lineIndex for the next line
//     lineIndex++;
//   });
// });



  
  $("#checker-submit").click(function() {
  $("input[name='ticket_sequence[]']").val(""); // Reset or empty the fields with the name "ticket_sequence"
  });

// Add line functionality
$(document).ready(function() {
//   $("#checker-add").click(function() {
//     var line = $(".line").last().clone();
//     line.find("input").val(""); // Clear input values in the cloned line
//     line.appendTo("#checker-lines");
//   });

  // Delete line functionality
  $(document).on("click", ".fa-trash", function() {
    $(this).closest(".line").remove();
  });

  // Move to next input when the current input reaches its maxlength
  $(document).on("input", "input[type='tel']", function() {
    if (this.value.length === this.maxLength) {
      $(this).closest("li").next("li").find("input").focus();
    }
  });

  // Allow only numeric input
  $(document).on("keypress", "input[type='tel']", function(e) {
    var keyCode = e.which ? e.which : e.keyCode;
    if (keyCode < 48 || keyCode > 57) {
      e.preventDefault();
    }
  });

  // Clear input values and result div on "clean" button click
  $(document).on("click", ".clean", function() {
    $(this).siblings("ul").find("input").val(""); // Clear input values
    $(this).siblings(".clean[data-type='result']").empty(); // Clear result div
  });
});


// Duplicate number check
$(document).ready(function() {
  $(document).on("blur", "input[type='tel']", function() {
    var $row = $(this).closest(".line");
    var $inputs = $row.find("input[type='tel']").not(this);
    var value = $(this).val();
    var duplicate = false;

    // Check if the input value is not empty
    if (value.trim() !== '') {
      $inputs.each(function() {
        if ($(this).val() === value) {
          duplicate = true;
          return false; // Exit the loop early if duplicate is found
        }
      });

      if (duplicate) {
        $(this).val(""); // Clear the input value if it is a duplicate
        Swal.fire({
          icon: 'error',
          title: 'Duplicate Number',
          text: 'Please enter a unique number within the row.',
          confirmButtonColor: '#3085d6',
          confirmButtonText: 'OK'
        });
      }
    }
  });
});



// Reset input values on clean button click
$(document).ready(function() {
  $(document).on("click", ".clean", function() {
    $(this).siblings("ul").find("input").val(""); // Clear input values
    $(this).siblings(".clean[data-type='result']").empty(); // Clear result div
  });
});


// Input validation for price field
$(document).ready(function() {
  $('#priceInput').on('change', function() {
    var price = $(this).val();
    var min = parseInt($(this).attr('min'));
    var max = parseInt($(this).attr('max'));

    if (price < min || price > max) {
      Swal.fire({
        icon: 'error',
        title: 'Invalid Amount',
        text: 'Please enter an amount between ' + min + ' and ' + max + '.',
      });
      $(this).val(min); // Reset the input to the minimum value
    }
  });
});


  // jQuery button click event to add a row
  // var rowIdx = '';
  // var maxRows = <?php echo e($gameDetail->game_total_allowed_ticket); ?>;
  // $('#addBtn').on('click', function () {
  //   var selectOptions = '';
  //   for (var i = 0; i <= 99; i++) {
  //     selectOptions += `<option value="${i}">${i}</option>`;
  //   }

  //   // Adding a row inside the tbody
  //   $('#tbody').append(`
  //     <tr>
  //       <td class="row-index text-center">${rowIdx + 1}</td>
  //       <td>
  //         <input class="form-control winning_number" name="name[]" id="" value="No ${rowIdx + 1}" readonly>
  //       </td>
  //       <td>
  //         <select class="form-control" name="range[]">
  //           <option value="">Select Range</option>
  //           ${selectOptions}
  //         </select>
  //       </td>
  //       <td class="text-center">
  //         <button class="btn btn-danger remove" type="button">Remove</button>
  //       </td>
  //     </tr>
  //   `);

  //   rowIdx++;
  //   if ($('#tbody tr').length >= maxRows) {
  //     $('#addBtn').hide();
  //   }
  // });

  // Check for duplicate numbers on select change event
  // $('#tbody').on('change', 'select[name="range[]"]', function () {
  //   var selectedNumbers = [];
  //   $('select[name="range[]"]').each(function () {
  //     var number = $(this).val();
  //     if (number !== '' && selectedNumbers.includes(number)) {
  //       // Show SweetAlert message for duplicate number
  //       Swal.fire({
  //         icon: 'error',
  //         title: 'Duplicate Number',
  //         text: 'Please select a unique range.',
  //       });
  //       $(this).val(''); // Clear the duplicate selection
  //     } else {
  //       selectedNumbers.push(number);
  //     }
  //   });
  // });

  // Remove row on button click
  // $('#tbody').on('click', '.remove', function () {
  //   $(this).closest('tr').remove();
  //   $('#addBtn').show();
  //   updateRowIndexes();
  // });

  // Update row indexes
//   function updateRowIndexes() {
//     $('#tbody .row-index').each(function (index) {
//       $(this).text(index + 1);
//     });
//   }
// });
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\Lotto\resources\views/front/ticket/create.blade.php ENDPATH**/ ?>